//Dustin Soodak

//Behavior 044: hacking IR
#include "MiscHardware.h"

#define BUF_LEN 5
uint8_t Data[BUF_LEN][2];
int first=0,last=0;

//note: in future, use structs (or use OOP and put in arduino include library)
void RecordIRRestart(int *first, int *last){//RecordIRRestart(&first,&last);
  *first=0;
  *last=0;
  RxIRRestart();
}
int RecordIRLength(int BufferLength,int *first, int *last){
  if(*last>=*first)
    return *last-*first;
  else
    return BufferLength;//will always be full in this case
}
int RecordIRBufferOffset(int BufferLength,int *first, int *last,int Position){
  int pos;
  if(*first+Position<BufferLength)
    return *first+Position;
  else
    return *first+Position-BufferLength;
}
int RecordIRSetTxArray(unsigned char *DataBuffer2Bytes, int BufferLength, int *first, int *last,int BufferElementNumber, char *TxArray){
  int offs;
  if(BufferElementNumber < RecordIRLength(BufferLength,first,last)){
    offs=RecordIRBufferOffset(BufferLength,first,last,BufferElementNumber);
    TxArray[0]=0x00;
    TxArray[1]=0xFF;
    TxArray[2]=DataBuffer2Bytes[offs*2+0];
    TxArray[3]=DataBuffer2Bytes[offs*2+1];
  }
}
void RecordIR(unsigned char *DataBuffer2Bytes, int BufferLength, int *first, int *last){//RecordIR(Data, BUF_LEN, &first, &last);
  int i;
  char match;
  RecordIR_Repeat:
  if(IsIRDone()){      
      RxIRStop();//clears IRReceiving as well   
           
      if(IRNumOfBytes==4){
        for(i=0;i<IRNumOfBytes;i++){
          Serial.println(((unsigned char)IRBytes[i]),HEX);
        }
        match=0;
        i=*first;
        Serial.println("search");
        do{
          Serial.print(i,DEC);Serial.print("_");Serial.print(DataBuffer2Bytes[i*2+0],HEX);Serial.print("_");Serial.print(DataBuffer2Bytes[i*2+1],HEX);Serial.print(" ");
          if(IRBytes[2]==DataBuffer2Bytes[i*2+0]){
            if(IRBytes[3]==DataBuffer2Bytes[i*2+1]){
              match=1;
              Serial.print("\r\nmatch at ");Serial.println(i,DEC);
              break;//exit for() loop
            }
          }
          i=((i+1)%BufferLength);
        }while(i!=((*last+1)%BufferLength));
        Serial.println("");
        if(!match){
          Serial.print("add at ");Serial.println(*last,DEC);
          DataBuffer2Bytes[*last*2+0]=IRBytes[2];
          DataBuffer2Bytes[*last*2+1]=IRBytes[3];
          *last=(*last+1)%BufferLength;
          if(*last==*first)
            *first=(*first+1)%BufferLength;            
        }
      }//end if(IRNumOfBytes==4)      
      RxIRRestart();
  }//end if(IsIRDone())   
  if(IRReceiving)
    goto RecordIR_Repeat;
}//end RecordIR()



int i;
int len,element;
//char randomized=0;
char TxData[4];//first 2 always the same
void setup(){
  HardwareBegin();   
  RecordIRRestart(&first, &last);
  RestartTimer();
  SwitchMotorsToSerial();
}
void loop(){
  RecordIR((unsigned char*)Data, BUF_LEN, &first, &last);//If IRReceiving, then this function waits till its done and records if 4 bytes received.
  if(GetTime()>2000){
    len=RecordIRLength(BUF_LEN, &first, &last);
    if(len>0){      
      //Serial debug:
      Serial.print("first ");Serial.print(first);Serial.print(" last ");Serial.println(last);
      for(i=0;i<len;i++){
        element=RecordIRBufferOffset(BUF_LEN,&first,&last,i);
        Serial.print(element,DEC);Serial.print(" ");
        Serial.print(Data[element][0],HEX);Serial.print(" ");Serial.print(Data[element][1],HEX);Serial.print(", ");
      }
      Serial.println();
      //Send randomly chosen IR:
      element=random(0,len);
      Serial.print("Sending number ");Serial.println(element);
      RecordIRSetTxArray((unsigned char*)Data, BUF_LEN, &first, &last,element, TxData);      
      TxIR(TxData,4);
      RxIRRestart();//since TxIR uses same timer as Rx, this is needed for RecordIR() to continue working
      RestartTimer();
    }
  }
  
}//end loop()







